/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability.object;

import dev.toma.gunsrpg.api.common.data.IHandState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class HandState
implements IHandState,
INBTSerializable<CompoundNBT> {
    private final ISyncRequestFactory requestFactory;
    private boolean busyHands;

    public HandState(ISyncRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    @Override
    public void setHandsBusy() {
        this.busyHands = true;
        this.requestFactory.makeSynchronizationRequest();
    }

    @Override
    public void freeHands() {
        boolean busy = this.busyHands;
        this.busyHands = false;
        if (busy != this.busyHands) {
            this.requestFactory.makeSynchronizationRequest();
        }
    }

    @Override
    public boolean areHandsBusy() {
        return this.busyHands;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("busyHands", this.busyHands);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.busyHands = nbt.func_74767_n("busyHands");
    }

    @FunctionalInterface
    public static interface ISyncRequestFactory {
        public void makeSynchronizationRequest();
    }
}

